/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.FP16;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class MathUtil {
    private static final boolean USE_SIN_TABLE = false;
    private static final float[] SIN_TABLE;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float PI3 = (float)Math.PI * 3;
    public static final float PI4 = (float)Math.PI * 4;
    public static final float PI_O_2 = 1.5707964f;
    public static final float PI_O_3 = 1.0471976f;
    public static final float PI_O_4 = 0.7853982f;
    public static final float PI_O_6 = 0.5235988f;
    public static final float EPS = 1.0E-5f;
    public static final float INV_EPS = 100000.0f;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.29578f;
    public static final float SQRT2 = 1.4142135f;
    public static final float INV_SQRT2 = 0.70710677f;
    public static final float PATH_TOLERANCE = 2.4414062E-4f;
    private static final MethodHandle FLOAT16_TO_FLOAT;
    private static final MethodHandle FLOAT_TO_FLOAT16;

    private static MethodHandle getFloat16ToFloat() {
        try {
            return MethodHandles.lookup().findStatic(Float.class, "float16ToFloat", MethodType.methodType(Float.TYPE, Short.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    private static MethodHandle getFloatToFloat16() {
        try {
            return MethodHandles.lookup().findStatic(Float.class, "floatToFloat16", MethodType.methodType(Short.TYPE, Float.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    private static float fsin(float a) {
        return SIN_TABLE[Math.round(a * 10430.378f) & 0xFFFF];
    }

    private static float fcos(float a) {
        return SIN_TABLE[Math.round(a * 10430.378f) + 16384 & 0xFFFF];
    }

    public static float sin(float a) {
        return (float)Math.sin(a);
    }

    public static float cos(float a) {
        return (float)Math.cos(a);
    }

    public static float tan(float a) {
        return (float)Math.tan(a);
    }

    public static float frexp(float x, int[] exp) {
        int bits = Float.floatToRawIntBits(x);
        int high = bits & Integer.MAX_VALUE;
        exp[0] = 0;
        if (high == 0 | high >= 2139095040) {
            return x;
        }
        if (high < 0x800000) {
            bits = Float.floatToRawIntBits(3.3554432E7f * x);
            high = bits & Integer.MAX_VALUE;
            exp[0] = -25;
        }
        exp[0] = exp[0] + ((high >> 23) - 126);
        return Float.intBitsToFloat(bits & 0x807FFFFF | 0x3F000000);
    }

    public static float ldexp(float x, int exp) {
        if (exp > 127) {
            x *= 1.7014118E38f;
            if ((exp -= 127) > 127) {
                x *= 1.7014118E38f;
                if ((exp -= 127) > 127) {
                    exp = 127;
                }
            }
        } else if (exp < -126) {
            x *= Float.MIN_NORMAL;
            if ((exp += 126) < -126) {
                x *= Float.MIN_NORMAL;
                if ((exp += 126) < -126) {
                    exp = -126;
                }
            }
        }
        return x * Float.intBitsToFloat(exp + 127 << 23);
    }

    public static boolean isApproxZero(float a) {
        return Math.abs(a) <= 1.0E-5f;
    }

    public static boolean isApproxZero(float a, float tolerance) {
        assert (tolerance >= 0.0f);
        return Math.abs(a) <= tolerance;
    }

    public static boolean isApproxEqual(float a, float b) {
        return Math.abs(a - b) <= 1.0E-5f;
    }

    public static boolean isApproxEqual(float a, float b, float tolerance) {
        assert (tolerance >= 0.0f);
        return Math.abs(a - b) <= tolerance;
    }

    public static float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public static float asin(float a) {
        return (float)Math.asin(a);
    }

    public static float acos(float a) {
        return (float)Math.acos(a);
    }

    public static float atan2(float a, float b) {
        return (float)Math.atan2(a, b);
    }

    public static int clamp(int x, int min, int max) {
        return Math.min(max, Math.max(x, min));
    }

    public static long clamp(long x, long min, long max) {
        return Math.min(max, Math.max(x, min));
    }

    public static float clamp(float x, float min, float max) {
        return Math.min(max, Math.max(x, min));
    }

    public static double clamp(double x, double min, double max) {
        return Math.min(max, Math.max(x, min));
    }

    public static float pin(float x, float min, float max) {
        float y = max < x ? max : x;
        return min < y ? y : min;
    }

    public static double pin(double x, double min, double max) {
        double y = max < x ? max : x;
        return min < y ? y : min;
    }

    public static float min(float a, float b, float c) {
        return Math.min(Math.min(a, b), c);
    }

    public static float min3(float[] v) {
        return Math.min(Math.min(v[0], v[1]), v[2]);
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static float min(float a, float b, float c, float d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public static double min(double a, double b, double c, double d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public static float max(float a, float b, float c) {
        return Math.max(Math.max(a, b), c);
    }

    public static float max3(float[] v) {
        return Math.max(Math.max(v[0], v[1]), v[2]);
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static float max(float a, float b, float c, float d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static double max(double a, double b, double c, double d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public static float median(float a, float b, float c) {
        return MathUtil.clamp(c, Math.min(a, b), Math.max(a, b));
    }

    public static double median(double a, double b, double c) {
        return MathUtil.clamp(c, Math.min(a, b), Math.max(a, b));
    }

    public static float lerp(float a, float b, float t) {
        return (b - a) * t + a;
    }

    public static double lerp(double a, double b, double t) {
        return (b - a) * t + a;
    }

    public static float mix(float a, float b, float t) {
        return a * (1.0f - t) + b * t;
    }

    public static double mix(double a, double b, double t) {
        return a * (1.0 - t) + b * t;
    }

    public static float biLerp(float q00, float q10, float q01, float q11, float tx, float ty) {
        return MathUtil.lerp(MathUtil.lerp(q00, q10, tx), MathUtil.lerp(q01, q11, tx), ty);
    }

    public static double biLerp(double q00, double q10, double q01, double q11, double tx, double ty) {
        return MathUtil.lerp(MathUtil.lerp(q00, q10, tx), MathUtil.lerp(q01, q11, tx), ty);
    }

    public static float triLerp(float c000, float c100, float c010, float c110, float c001, float c101, float c011, float c111, float tx, float ty, float tz) {
        return MathUtil.lerp(MathUtil.biLerp(c000, c100, c010, c110, tx, ty), MathUtil.biLerp(c001, c101, c011, c111, tx, ty), tz);
    }

    public static double triLerp(double c000, double c100, double c010, double c110, double c001, double c101, double c011, double c111, double tx, double ty, double tz) {
        return MathUtil.lerp(MathUtil.biLerp(c000, c100, c010, c110, tx, ty), MathUtil.biLerp(c001, c101, c011, c111, tx, ty), tz);
    }

    public static boolean isFinite(float v0, float v1, float v2, float v3) {
        float prod = v0 - v0;
        return (prod = prod * v1 * v2 * v3) == prod;
    }

    public static boolean isFinite(float v0, float v1, float v2, float v3, float v4, float v5) {
        float prod = v0 - v0;
        return (prod = prod * v1 * v2 * v3 * v4 * v5) == prod;
    }

    public static boolean isFinite(float v0, float v1, float v2, float v3, float v4, float v5, float v6, float v7, float v8) {
        float prod = v0 - v0;
        return (prod = prod * v1 * v2 * v3 * v4 * v5 * v6 * v7 * v8) == prod;
    }

    public static boolean isFinite(float[] values, int offset, int count) {
        assert (count > 0);
        float v0 = values[offset];
        float prod = v0 - v0;
        while (--count != 0) {
            prod *= values[++offset];
        }
        return prod == prod;
    }

    public static int align2(int a) {
        assert (a >= 0 && a <= 0x7FFFFFF7);
        return a + 1 & 0xFFFFFFFE;
    }

    public static int align4(int a) {
        assert (a >= 0 && a <= 0x7FFFFFF7);
        return a + 3 & 0xFFFFFFFC;
    }

    public static int align8(int a) {
        assert (a >= 0 && a <= 0x7FFFFFF7);
        return a + 7 & 0xFFFFFFF8;
    }

    public static long align2(long a) {
        assert (a >= 0L && a <= 0x7FFFFFFFFFFFFFEFL);
        return a + 1L & 0xFFFFFFFFFFFFFFFEL;
    }

    public static long align4(long a) {
        assert (a >= 0L && a <= 0x7FFFFFFFFFFFFFEFL);
        return a + 3L & 0xFFFFFFFFFFFFFFFCL;
    }

    public static long align8(long a) {
        assert (a >= 0L && a <= 0x7FFFFFFFFFFFFFEFL);
        return a + 7L & 0xFFFFFFFFFFFFFFF8L;
    }

    public static boolean isAlign2(int a) {
        assert (a >= 0);
        return (a & 1) == 0;
    }

    public static boolean isAlign4(int a) {
        assert (a >= 0);
        return (a & 3) == 0;
    }

    public static boolean isAlign8(int a) {
        assert (a >= 0);
        return (a & 7) == 0;
    }

    public static boolean isAlign2(long a) {
        assert (a >= 0L);
        return (a & 1L) == 0L;
    }

    public static boolean isAlign4(long a) {
        assert (a >= 0L);
        return (a & 3L) == 0L;
    }

    public static boolean isAlign8(long a) {
        assert (a >= 0L);
        return (a & 7L) == 0L;
    }

    public static int alignTo(int a, int alignment) {
        assert (alignment > 0 && (alignment & alignment - 1) == 0);
        return a + alignment - 1 & -alignment;
    }

    public static long alignTo(long a, long alignment) {
        assert (alignment > 0L && (alignment & alignment - 1L) == 0L);
        return a + alignment - 1L & -alignment;
    }

    public static int alignUp(int a, int alignment) {
        assert (alignment > 0);
        int r = a % alignment;
        return r == 0 ? a : a + alignment - r;
    }

    public static int alignUpPad(int a, int alignment) {
        assert (alignment > 0);
        return (alignment - a % alignment) % alignment;
    }

    public static int alignDown(int a, int alignment) {
        assert (alignment > 0);
        return a / alignment * alignment;
    }

    public static boolean isPow2(int a) {
        assert (a > 0) : "undefined";
        return (a & a - 1) == 0;
    }

    public static boolean isPow2(long a) {
        assert (a > 0L) : "undefined";
        return (a & a - 1L) == 0L;
    }

    public static int ceilLog2(int a) {
        assert (a > 0) : "undefined";
        return 32 - Integer.numberOfLeadingZeros(a - 1);
    }

    public static int ceilLog2(long a) {
        assert (a > 0L) : "undefined";
        return 64 - Long.numberOfLeadingZeros(a - 1L);
    }

    public static int ceilPow2(int a) {
        assert (a > 0 && a <= 0x40000000) : "undefined";
        return 1 << -Integer.numberOfLeadingZeros(a - 1);
    }

    public static long ceilPow2(long a) {
        assert (a > 0L && a <= 0x4000000000000000L) : "undefined";
        return 1L << -Long.numberOfLeadingZeros(a - 1L);
    }

    public static int floorLog2(int a) {
        assert (a > 0) : "undefined";
        return 31 - Integer.numberOfLeadingZeros(a);
    }

    public static int floorLog2(long a) {
        assert (a > 0L) : "undefined";
        return 63 - Long.numberOfLeadingZeros(a);
    }

    public static int floorPow2(int a) {
        assert (a > 0) : "undefined";
        return Integer.highestOneBit(a);
    }

    public static long floorPow2(long a) {
        assert (a > 0L) : "undefined";
        return Long.highestOneBit(a);
    }

    public static int ceilLog2(float v) {
        int exp = (Float.floatToRawIntBits(v) + 0x800000 - 1 >> 23) - 127;
        return exp & ~(exp >> 31);
    }

    public static int ceilLog4(float v) {
        return MathUtil.ceilLog2(v) + 1 >> 1;
    }

    public static int ceilLog16(float v) {
        return MathUtil.ceilLog2(v) + 3 >> 2;
    }

    public static float halfToFloat(short h) {
        if (FLOAT16_TO_FLOAT != null) {
            try {
                return FLOAT16_TO_FLOAT.invokeExact(h);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return FP16.toFloat(h);
    }

    public static short floatToHalf(float f) {
        if (FLOAT_TO_FLOAT16 != null) {
            try {
                return FLOAT_TO_FLOAT16.invokeExact(f);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return FP16.toHalf(f);
    }

    protected MathUtil() {
        throw new UnsupportedOperationException();
    }

    static {
        FLOAT16_TO_FLOAT = MathUtil.getFloat16ToFloat();
        FLOAT_TO_FLOAT16 = MathUtil.getFloatToFloat16();
        SIN_TABLE = null;
    }
}

